% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_augment}
\alias{stat_fit_augment}
\title{Augment data with fitted values and statistics}
\usage{
stat_fit_augment(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  method = "lm",
  method.args = list(formula = y ~ x),
  augment.args = list(),
  level = 0.95,
  y.out = ".fitted",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character or function.}

\item{method.args, augment.args}{list of arguments to pass to \code{method}
and to to \code{broom:augment}.}

\item{level}{numeric Level of confidence interval to use (0.95 by default)}

\item{y.out}{character (or numeric) index to column to return as \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_fit_augment} fits a model and returns a "tidy"
  version of the model's data with prediction added, using '\code{augmnent()}
  methods from packages 'broom', 'broom.mixed', or other sources. The
  prediction can be added to the plot as a curve.
}
\details{
\code{stat_fit_augment} together with \code{\link{stat_fit_glance}}
  and \code{\link{stat_fit_tidy}}, based on package 'broom' can be used
  with a broad range of model fitting functions as supported at any given
  time by 'broom'. In contrast to \code{\link{stat_poly_eq}} wich can
  generate text or expression labels automatically, for these functions the
  mapping of aesthetic \code{label} needs to be explicitly supplied in the
  call, and labels built on the fly.

  A ggplot statistic receives as data a data frame that is not the one passed
  as argument by the user, but instead a data frame with the variables mapped
  to aesthetics. In other words, it respects the grammar of graphics and
  consequently within arguments passed through \code{method.args} names of
  aesthetics like $x$ and $y$ should be used intead of the original variable
  names, while data is automatically passed the data frame. This helps ensure
  that the model is fitted to the same data as plotted in other layers.
}
\note{
The statistic \code{stat_fit_augment} can be used only with
  \code{methods} that accept formulas under any formal parameter name and a
  \code{data} argument. Use \code{ggplot2::stat_smooth()} instead of
  \code{stat_fit_augment} in production code if the additional features are
  not needed.

Although arguments passed to parameter \code{augment.args} will be
  passed to [generics::augment()] whether they are silently ignored or obeyed
  depends on each specialization of [augment()], so do carefully read the
  documentation for the version of [augment()] corresponding to the `method`
  used to fit the model.
}
\section{Warning!}{
 Not all `glance()` methods are defined in package 'broom'.
  `glance()` especializations for mixed models fits of classes `lme`, `nlme`,
  `lme4`, and many others are defined in package 'broom.mixed'.
}

\section{Handling of grouping}{
 \code{stat_fit_augment} applies the function
  given by \code{method} separately to each group of observations; in ggplot2
  factors mapped to aesthetics generate a separate group for each level.
  Because of this, \code{stat_fit_augment} is not useful for annotating plots
  with results from \code{t.test()} or ANOVA or ANCOVA. In such cases use
  instead \code{stat_fit_tb()} which applies the model fitting per panel.
}

\section{Computed variables}{
 The output of \code{augment()} is
  returned as is, except for \code{y} which is set based on \code{y.out} and
  \code{y.observed} which preserves the \code{y} returned by the
  \code{generics::augment} methods. This renaming is needed so that the geom
  works as expected.

  To explore the values returned by this statistic, which vary depending
  on the model fitting function and model formula we suggest the use of
  \code{\link[gginnards]{geom_debug}}. An example is shown below.
}

\examples{
library(broom)
library(gginnards)
library(quantreg)

# Regression by panel, using geom_debug() to explore computed variables
ggplot(mtcars, aes(x = disp, y = mpg)) +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_augment(method = "lm",
                   method.args = list(formula = y ~ x),
                   geom = "debug",
                   summary.fun = colnames)

# Regression by panel example
ggplot(mtcars, aes(x = disp, y = mpg)) +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_augment(method = "lm",
                   method.args = list(formula = y ~ x))

# Residuals from regression by panel example
ggplot(mtcars, aes(x = disp, y = mpg)) +
  geom_hline(yintercept = 0, linetype = "dotted") +
  stat_fit_augment(geom = "point",
                   method = "lm",
                   method.args = list(formula = y ~ x),
                   y.out = ".resid")

# Regression by group example
ggplot(mtcars, aes(x = disp, y = mpg, colour = factor(cyl))) +
  geom_point() +
  stat_fit_augment(method = "lm",
                   method.args = list(formula = y ~ x))

# Residuals from regression by group example
ggplot(mtcars, aes(x = disp, y = mpg, colour = factor(cyl))) +
  geom_hline(yintercept = 0, linetype = "dotted") +
  stat_fit_augment(geom = "point",
                   method.args = list(formula = y ~ x),
                   y.out = ".resid")

# Weighted regression example
ggplot(mtcars, aes(x = disp, y = mpg, weight = cyl)) +
  geom_point(aes(colour = factor(cyl))) +
  stat_fit_augment(method = "lm",
                   method.args = list(formula = y ~ x,
                                 weights = quote(weight)))

# Residuals from weighted regression example
ggplot(mtcars, aes(x = disp, y = mpg, weight = cyl)) +
  geom_hline(yintercept = 0, linetype = "dotted") +
  stat_fit_augment(geom = "point",
                   method.args = list(formula = y ~ x,
                                 weights = quote(weight)),
                   y.out = ".resid")

# Quantile regression
ggplot(mtcars, aes(x = disp, y = mpg)) +
  geom_point() +
  stat_fit_augment(method = "rq",
                  label.y = "bottom")

}
\seealso{
\code{\link[broom]{broom}} and \code{broom.mixed} for details on how
  the tidying of the result of model fits is done.

Other Statistics calling generic tidier methods.: 
\code{\link{stat_fit_glance}()},
\code{\link{stat_fit_tb}()},
\code{\link{stat_fit_tidy}()}
}
\concept{Statistics calling generic tidier methods.}
