% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_node_plot.R
\name{geom_node_plot}
\alias{geom_node_plot}
\title{Draw plots at nodes}
\usage{
geom_node_plot(plot_call = "ggplot", gglist = NULL, width = 1,
  height = 1, size = 1, ids = "terminal", scales = "fixed",
  nudge_x = 0, nudge_y = 0, shared_axis_labels = FALSE,
  shared_legend = TRUE, predict = NULL, predict_gpar = NULL,
  legend_separator = FALSE)
}
\arguments{
\item{plot_call}{Any function that generates a \code{ggplot2} object.}

\item{gglist}{List of additional \code{gg} components. Columns of \code{data} of nodes can be
mapped. Additionally \code{fitted_values} and \code{residuals} can be mapped if present in
\code{party} of \code{ggparty()}}

\item{width}{Expansion factor for viewport's width.}

\item{height}{Expansion factor for viewport's height.}

\item{size}{Expansion factor for viewport's size.}

\item{ids}{Id's to plot. Numeric, "terminal", "inner" or "all". Defaults
to "terminal".}

\item{scales}{See \code{\link[=facet_wrap]{facet_wrap()}}}

\item{nudge_x, nudge_y}{Nudges node plot.}

\item{shared_axis_labels}{If TRUE only one pair of axes labels is plotted in
the terminal space. Only recommended if \code{ids}  "terminal" or "all".}

\item{shared_legend}{If \code{TRUE} one shared legend is plotted at the bottom of
the tree.}

\item{predict}{Character string specifying variable for which predictions should be plotted.}

\item{predict_gpar}{Named list containing arguments to be passed to the
\code{geom_line()} call of predicted values.}

\item{legend_separator}{If \code{TRUE} line between legend and tree is drawn.}
}
\description{
Additional component for a \code{\link[=ggparty]{ggparty()}} that allows to create in each node a
ggplot with its data. #'
}
\examples{

library(ggparty)

airq <- subset(airquality, !is.na(Ozone))
airct <- ctree(Ozone ~ ., data = airq)

ggparty(airct, horizontal = TRUE, terminal_space = 0.6) +
  geom_edge() +
  geom_edge_label() +
  geom_node_splitvar() +
  geom_node_plot(gglist = list(
    geom_density(aes(x = Ozone))),
    shared_axis_labels = TRUE)

#############################################################

## Plot with ggparty


## Demand for economics journals data
data("Journals", package = "AER")
Journals <- transform(Journals,
                      age = 2000 - foundingyear,
                      chars = charpp * pages)

## linear regression tree (OLS)
j_tree <- lmtree(log(subs) ~ log(price/citations) | price + citations +
                   age + chars + society, data = Journals, minsize = 10, verbose = TRUE)

pred_df <- get_predictions(j_tree, ids = "terminal", newdata =  function(x) {
  data.frame(
    citations = 1,
    price = exp(seq(from = min(x$`log(price/citations)`),
                    to = max(x$`log(price/citations)`),
                    length.out = 100)))
})

ggparty(j_tree, terminal_space = 0.8) +
  geom_edge() +
  geom_edge_label() +
  geom_node_splitvar() +
  geom_node_plot(gglist =
                   list(aes(x = `log(price/citations)`, y = `log(subs)`),
                        geom_point(),
                        geom_line(data = pred_df,
                                  aes(x = log(price/citations),
                                      y = prediction),
                                  col = "red")))
}
\seealso{
\code{\link[=ggparty]{ggparty()}}
}
