% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-nodes.R
\name{geom_nodes}
\alias{geom_nodes}
\title{Draw the nodes of a network.}
\usage{
geom_nodes(mapping = NULL, data = NULL, position = "identity",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
All arguments to this geom are identical to those of
\code{\link[ggplot2]{geom_point}}.
}
\examples{
if (require(network) && require(sna)) {

data(flo, package = "network")
n <- network(flo, directed = FALSE)

# just nodes
ggplot(n, aes(x, y)) +
  geom_nodes(size = 3, shape = 21, color = "steelblue") +
  theme_blank()

# with edges
ggplot(n, aes(x, y, xend = xend, yend = yend)) +
  geom_edges(color = "steelblue") +
  geom_nodes(size = 3, shape = 21, color = "steelblue", fill = "white") +
  theme_blank()

# with nodes sized according to degree centrality
ggplot(n, aes(x, y, xend = xend, yend = yend)) +
  geom_edges(color = "steelblue") +
  geom_nodes(size = degree(n), shape = 21, color = "steelblue", fill = "white") +
  theme_blank()

# with nodes colored according to betweenness centrality

n \%v\% "betweenness" <- betweenness(flo)
ggplot(n, aes(x, y, xend = xend, yend = yend)) +
  geom_edges(color = "grey50") +
  geom_nodes(aes(color = betweenness), size = 3) +
  scale_color_gradient(low = "gold", high = "tomato") +
  theme_blank() +
  theme(legend.position = "bottom")

}
}

