% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_dendrogram.R
\name{guide_dendro}
\alias{guide_dendro}
\title{Dendrogram guide}
\usage{
guide_dendro(
  title = waiver(),
  check.overlap = FALSE,
  n.dodge = 1,
  order = 0,
  position = waiver(),
  label = TRUE,
  trunc_lower = NULL,
  trunc_upper = NULL,
  colour = NULL,
  color = NULL,
  dendro = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{A positive \code{integer} of length 1 that specifies the order of
this guide among multiple guides. This controls in which order guides are
merged if there are multiple guides for the same position. If 0 (default),
the order is determined by a secret algorithm.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}

\item{label}{A \code{logical(1)}. If \code{TRUE}, labels are drawn at the
dendrogram leaves. If \code{FALSE}, labels are not drawn.}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{dendro}{Relevant plotting data for a dendrogram such as those returned
by \code{\link[ggdendro:dendro_data]{ggdendro::dendro_data()}}.}
}
\value{
A \emph{dendroguide} class object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Visual representation of a discrete variable with hierarchical relationships
between members, like those detailed in
\code{\link[=scale_x_dendrogram]{scale_(x|y)_dendrogram)()}}. This function is
deprecated in favour of \code{legendry::guide_axis_dendro()}.
}
\details{
The dendrogram guide inherits graphical elements from the
\code{axis.ticks} theme element. However, the size of the dendrogram is set
to 10 times the \code{axis.ticks.length} theme element.
}
\examples{
clust <- hclust(dist(USArrests), "ave")

# Melting USArrests
df <- data.frame(
  State = rownames(USArrests)[row(USArrests)],
  variable = colnames(USArrests)[col(USArrests)],
  value = unname(do.call(c, USArrests))
)

# The guide function can be used to customise the axis
g <- ggplot(df, aes(variable, State, fill = value)) +
  geom_raster() +
  scale_y_dendrogram(hclust = clust,
                     guide = guide_dendro(n.dodge = 2))

# The looks of the dendrogram are controlled through ticks
g + theme(axis.ticks = element_line(colour = "red"))

# The size of the dendrogram is controlled through tick size * 10
g + theme(axis.ticks.length = unit(5, "pt"))
}
\keyword{internal}
