% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghost.R
\name{+.gg}
\alias{+.gg}
\title{Add a New ggplot Component to a ggghost Object}
\usage{
\method{+}{gg}(e1, e2)
}
\arguments{
\item{e1}{An object of class \code{ggghost}}

\item{e2}{A component to add to \code{e1}}
}
\value{
Appends the \code{e2} call to the \code{ggghost} structure
}
\description{
This operator allows you to add objects to a ggghost object in the style of @hrbrmstr.
}
\examples{
#' ## create a ggghost object
tmpdata <- data.frame(x = 1:100, y = rnorm(100))

z \%g<\% ggplot(tmpdata, aes(x,y))
z <- z + geom_point(col = "steelblue")
z <- z + theme_bw()
z <- z + labs(title = "My cool ggplot")
z <- z + labs(x = "x axis", y = "y axis")
z <- z + geom_smooth()
}

