% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/craft-align-.R
\docType{data}
\name{align}
\alias{align}
\alias{CraftAlign}
\title{Create a New \code{CraftBox} Object with \code{CraftAlign} craftsman}
\usage{
align(
  align,
  data = NULL,
  ...,
  plot = NULL,
  size = NULL,
  schemes = NULL,
  active = NULL,
  no_axes = deprecated(),
  call = caller_call()
)
}
\arguments{
\item{align}{An \code{CraftAlign} object.}

\item{data}{The following options can be used:
\itemize{
\item \code{NULL}: No data is set.
\item \code{\link[ggplot2:waiver]{waiver()}}: Inherits the data from the layout matrix.
\item A \code{function} (including purrr-like lambda syntax): Applied to the layout
matrix to transform the data before use. To transform the final plot
data, please use \code{\link[=scheme_data]{scheme_data()}}.
\item A \code{matrix}, \code{data.frame}, or atomic vector.
}}

\item{...}{Additional fields passed to the \code{align} object.}

\item{plot}{A ggplot object.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{schemes}{Options for \code{schemes}:
\itemize{
\item \code{NULL}: Used when \code{align} do not add a plot.
\item \code{\link[ggplot2:waiver]{waiver()}}: Try to infer \code{schemes} based on \code{data}.
}}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please add
\code{\link[ggplot2:theme]{theme()}} directly to the ggplot instead.}

\item{call}{The \code{call} used to construct the \code{align} object, for
reporting messages.}
}
\value{
A new \code{CraftBox} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

An \code{CraftAlign} object interacts with the \code{Layout} object to reorder or split
observations and, in some cases, add plot components to the \code{Layout}.
}
\details{
Each of the \verb{Align*} objects is just a \code{\link[ggplot2:ggproto]{ggproto()}}
object, descended from the top-level \code{CraftAlign}, and each implements
various methods and fields.

To create a new type of \verb{Align*} object, you typically will want to
override one or more of the following:
\itemize{
\item \code{setup_params}: Prepare parameter or check parameters used by this plot.
\item \code{setup_data}: Prepare data used by this plot.
\item \code{compute}: A method used to compute statistics.
\item \code{align}: A method used to group observations into panel or reorder
observations.
\item \code{draw}: A method used to draw the plot. Must return a \code{ggplot} object.
}
}
\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
align_dendro()
}
\keyword{datasets}
\keyword{internal}
