% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_partial_coplot.R
\name{gg_partial_coplot.rfsrc}
\alias{gg_partial_coplot.rfsrc}
\alias{gg_partial_coplot}
\title{Data structures for stratified partial coplots}
\usage{
\method{gg_partial_coplot}{rfsrc}(
  object,
  xvar,
  groups,
  surv_type = c("mort", "rel.freq", "surv", "years.lost", "cif", "chf"),
  time,
  show_plots = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{\link[randomForestSRC]{rfsrc}} object}

\item{xvar}{list of partial plot variables}

\item{groups}{vector of stratification variable.}

\item{surv_type}{for survival random forests,  c("mort", "rel.freq", "surv",
"years.lost", "cif", "chf")}

\item{time}{vector of time points for survival random forests partial plots.}

\item{show_plots}{boolean passed to 
\code{\link[randomForestSRC]{plot.variable}} show.plots argument.}

\item{...}{extra arguments passed to
\code{\link[randomForestSRC]{plot.variable}} function}
}
\value{
\code{gg_partial_coplot} object. An subclass of a
\code{\link{gg_partial_list}} object
}
\description{
Data structures for stratified partial coplots
}
\examples{
\dontrun{

## ------------------------------------------------------------
## -------- pbc data
# We need to create this dataset
data(pbc, package = "randomForestSRC") 
# For whatever reason, the age variable is in days... makes no sense to me
for (ind in seq_len(dim(pbc)[2])) {
 if (!is.factor(pbc[, ind])) {
   if (length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 2) {
     if (sum(range(pbc[, ind], na.rm = TRUE) == c(0, 1)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
   }
 } else {
   if (length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 2) {
     if (sum(sort(unique(pbc[, ind])) == c(0, 1)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
     if (sum(sort(unique(pbc[, ind])) == c(FALSE, TRUE)) == 2) {
       pbc[, ind] <- as.logical(pbc[, ind])
     }
   }
 }
 if (!is.logical(pbc[, ind]) &
     length(unique(pbc[which(!is.na(pbc[, ind])), ind])) <= 5) {
   pbc[, ind] <- factor(pbc[, ind])
 }
}
#Convert age to years
pbc$age <- pbc$age / 364.24

pbc$years <- pbc$days / 364.24
pbc <- pbc[, -which(colnames(pbc) == "days")]
pbc$treatment <- as.numeric(pbc$treatment)
pbc$treatment[which(pbc$treatment == 1)] <- "DPCA"
pbc$treatment[which(pbc$treatment == 2)] <- "placebo"
pbc$treatment <- factor(pbc$treatment)
dta_train <- pbc[-which(is.na(pbc$treatment)), ]
# Create a test set from the remaining patients
 pbc_test <- pbc[which(is.na(pbc$treatment)), ]

#========
# build the forest:
rfsrc_pbc <- randomForestSRC::rfsrc(
  Surv(years, status) ~ .,
 dta_train,
 nsplit = 10,
 na.action = "na.impute",
 forest = TRUE,
 importance = TRUE,
 save.memory = TRUE
)
# Create the variable plot.
ggvar <- gg_variable(rfsrc_pbc, time = 1)

# Find intervals with similar number of observations.
copper_cts <- quantile_pts(ggvar$copper, groups = 6, intervals = TRUE)

# Create the conditional groups and add to the gg_variable object
copper_grp <- cut(ggvar$copper, breaks = copper_cts)

## We would run this, but it's expensive
partial_coplot_pbc <- gg_partial_coplot(rfsrc_pbc, xvar = "bili",
                                         groups = copper_grp,
                                         surv_type = "surv",
                                         time = 1,
                                         show.plots = FALSE)

# Partial coplot
plot(partial_coplot_pbc) #, se = FALSE)
}

}
