% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aacf.R
\name{stxr}
\alias{stxr}
\title{Estimate Texture Aspect Ratio}
\usage{
stxr(x, threshold = c(0.2, 1/exp(1)))
}
\arguments{
\item{x}{A raster or matrix.}

\item{threshold}{A vector of autocorrelation values with values
between 0 and 1. Indicates the autocorrelation value(s) to
which the rates of decline are measured.}
}
\value{
A vector with length equal to that of \code{threshold}
  containing the texture aspect ratio(s) for the input autocorrelation
  value(s).
}
\description{
Calculates the texture aspect ratio (Str) at defined autocorrelation
values. The texture aspect ratio is the ratio of the fastest to
the slowest decay lengths of the autocorrelation function to the
defined autocorrelation values.
}
\examples{
library(raster)

# import raster image
data(normforest)

# estimate the texture aspect ratio for autocorrelation
# thresholds of 0.20 and 0.37 (1/e)
strvals <- stxr(normforest, threshold = c(0.20, 1 / exp(1)))

# calculate Str20, the texture aspect ratio for
# autocorrelation value of 0.2 in the AACF
Str20 <- strvals[1]
}
