% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalraster_proc.R
\name{dem_proc}
\alias{dem_proc}
\title{GDAL DEM processing}
\usage{
dem_proc(
  mode,
  srcfile,
  dstfile,
  mode_options = DEFAULT_DEM_PROC[[mode]],
  color_file = NULL,
  quiet = FALSE
)
}
\arguments{
\item{mode}{Character. Name of the DEM processing mode. One of hillshade,
slope, aspect, color-relief, TRI, TPI or roughness.}

\item{srcfile}{Filename of the source elevation raster.}

\item{dstfile}{Filename of the output raster.}

\item{mode_options}{An optional character vector of command-line options
(see \link{DEFAULT_DEM_PROC} for default values).}

\item{color_file}{Filename of a text file containing lines formatted as:
"elevation_value red green blue". Only used when \code{mode = "color-relief"}.}

\item{quiet}{Logical scalar. If \code{TRUE}, a progress bar will not be
displayed. Defaults to \code{FALSE}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{dem_proc()} generates DEM derivatives from an input elevation raster. This
function is a wrapper for the \command{gdaldem} command-line utility.
See \url{https://gdal.org/en/stable/programs/gdaldem.html} for details.
}
\note{
Band 1 of the source elevation raster is read by default, but this can be
changed by including a \code{-b} command-line argument in \code{mode_options}.
See the \href{https://gdal.org/en/stable/programs/gdaldem.html}{documentation for
\code{gdaldem}} for a description of all available options for each processing
mode.
}
\examples{
## hillshade
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
out_file <- file.path(tempdir(), "storml_hillshade.tif")
dem_proc("hillshade", elev_file, out_file)

ds <- new(GDALRaster, out_file)
plot_raster(ds)

ds$close()
\dontshow{deleteDataset(out_file)}
}
