% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate_flat_file.R
\name{deprecate_flat_file}
\alias{deprecate_flat_file}
\title{Deprecate a flat file}
\usage{
deprecate_flat_file(flat_file)
}
\arguments{
\item{flat_file}{Path to the flat file to deprecate}
}
\value{
Used for side effect.
Move flat file to "dev/flat_history", update config file,
and remove "do not edit by hand" message.
}
\description{
It is not inflated again during \verb{[inflate_all()]} as it is
identified as deprecated in the config file.
Previously generated files get "do not edit by hand" message removed.
The flat file is moved to "dev/flat_history".
}
\examples{
\dontrun{
# These functions change the current user workspace
dev_file <- suppressMessages(
  add_flat_template(
    template = "add",
    pkg = dummypackage,
    overwrite = TRUE,
    open = FALSE
  )
)
deprecate_flat_file(flat_file = "dev/flat_additional.Rmd")
}
}
