% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestLayer.R
\name{TestLayer}
\alias{TestLayer}
\title{TestLayer Class}
\description{
This class implements a layer. A \link{TestLayer} object can only exist as a component of a \link{Predicting} object.

A predicted layer can only contain \link{TestData}.
}
\seealso{
\link{Training}, \link{Lrner}, \link{TrainData}, \link{TestData} and \link{Model}
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{TestLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestLayer-new}{\code{TestLayer$new()}}
\item \href{#method-TestLayer-print}{\code{TestLayer$print()}}
\item \href{#method-TestLayer-getTesting}{\code{TestLayer$getTesting()}}
\item \href{#method-TestLayer-getIndIDs}{\code{TestLayer$getIndIDs()}}
\item \href{#method-TestLayer-getTestData}{\code{TestLayer$getTestData()}}
\item \href{#method-TestLayer-checkTestDataExist}{\code{TestLayer$checkTestDataExist()}}
\item \href{#method-TestLayer-summary}{\code{TestLayer$summary()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$new(id, testing)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr
Testing layer id.}

\item{\code{testing}}{\code{Testing}\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-getTesting"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-getTesting}{}}}
\subsection{Method \code{getTesting()}}{
Getter of the current Testing object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$getTesting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current Testing object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Getter of IDS from the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-getTestData"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-getTestData}{}}}
\subsection{Method \code{getTestData()}}{
Getter of the predicted data stored on the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$getTestData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{TestData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-checkTestDataExist"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-checkTestDataExist}{}}}
\subsection{Method \code{checkTestDataExist()}}{
Check whether a new data has been already stored.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$checkTestDataExist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestLayer-summary"></a>}}
\if{latex}{\out{\hypertarget{method-TestLayer-summary}{}}}
\subsection{Method \code{summary()}}{
Generate summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestLayer$summary()}\if{html}{\out{</div>}}
}

}
}
