% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_aircrafts.R
\name{read_aircrafts}
\alias{read_aircrafts}
\title{Download aircrafts data from Brazil}
\usage{
read_aircrafts(date = 202001, showProgress = TRUE, cache = TRUE)
}
\arguments{
\item{date}{Numeric. Date of the data in the format \code{yyyymm}. Defaults to
\code{202001}. To download the data for all months in a year, the user
can pass a 4-digit year input \code{yyyy}. The function also accepts a
vector of dates, like \code{c(202201, 202301)} or \code{c(2022, 2024)}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress.}

\item{cache}{Logical. Whether the function should read cached data downloaded
previously. Defaults to \code{TRUE}. If \code{FALSE}, the function will
always download the data and overwrite cached data.}
}
\value{
A \verb{"data.table" "data.frame"} object. All columns are returned with
\code{class} of type \code{"character"}.
}
\description{
Download data of all aircrafts registered in the Brazilian Aeronautical
Registry (Registro Aeronáutico Brasileiro - RAB), organized by the Brazilian
Civil Aviation Agency (ANAC). A description of all variables included in the
data is available at \url{https://www.gov.br/anac/pt-br/sistemas/rab}.
}
\examples{
\dontrun{ if (interactive()) {
# Read aircrafts data
aircrafts <- read_aircrafts(date = 202001,
                            showProgress = TRUE)


}}
}
\seealso{
Other download flight data: 
\code{\link{read_flights}()}
}
\concept{download flight data}
