% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_pattern.R
\name{missing_pattern}
\alias{missing_pattern}
\title{Characterise missing data for \code{finalfit} models}
\usage{
missing_pattern(
  .data,
  dependent = NULL,
  explanatory = NULL,
  rotate.names = TRUE,
  ...
)
}
\arguments{
\item{.data}{Data frame. Missing values must be coded \code{NA}.}

\item{dependent}{Character vector usually of length 1, name of depdendent
variable.}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{rotate.names}{Logical. Should the orientation of variable names on plot
should be vertical.}

\item{...}{pass other arguments such as \code{plot = TRUE} to
\code{\link[mice]{md.pattern}}.}
}
\value{
A matrix with \code{ncol(x)+1} columns, in which each row corresponds
  to a missing data pattern (1=observed, 0=missing). Rows and columns are
  sorted in increasing amounts of missing information. The last column and
  row contain row and column counts, respectively.
}
\description{
Using \code{finalfit} conventions, produces a missing data matrix using
\code{\link[mice]{md.pattern}}.
}
\examples{
library(finalfit)
library(dplyr)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
	missing_pattern(dependent, explanatory)

}
