% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgm.R
\name{fgm}
\alias{fgm}
\title{Functional Gaussian Graphical Model}
\usage{
fgm(y, L, alpha, gamma, t = seq(0, 1, length.out = dim(y[[1]])[2]),
  thr.FVE = 95, include.Omega = FALSE)
}
\arguments{
\item{y}{list of length p containing densely observed multivariate (p-dimensional) functional data. \code{y[[j]]} is an nxm matrix of functional data for n subjects observed on a grid of length m}

\item{L}{the number of eigenfunctions used for dimension reduction using the partially separable Karhunen-Loeve (PSKL) expansion obtained using `pfpca()`. This argument can take positive integer values greater or equal to 1.}

\item{alpha}{penalty parameter for the common sparsity pattern taking values in \code{[0,1]}.}

\item{gamma}{penalty parameter for the overall sparsity pattern taking positive values.}

\item{t}{(optional) grid on which functional data is observed, defaults to \code{seq(0, 1, m)} where \code{m = dim(data[[1]])[2]}.}

\item{thr.FVE}{this parameter sets a threshold for the minimum percentage of functional variance explained (FVE) by the PSKL eigenfunctions (obtained using `pfpca()`). This criterion is used only if a value for L is not provided or is greater than the maximum possible number of eigenfunctions estimated from \code{y} using \code{pfpca()}.}

\item{include.Omega}{logical variable indicating wheter to include the list of precision matrices in the output. Default value is FALSE.}
}
\value{
A list with letters and numbers.
\describe{
  \item{\code{A}}{Resulting adjacency matrix as the union of all the Omega matrices}
  \item{\code{L}}{number of PSKL expansion eigenfunctions considered for the estimation of the graphical model.}
  \item{\code{Omega}}{list of of precision matrices obtained using the multivariate functional principal component scores theta obtained using `fpca()`}
}
}
\description{
Estimates a sparse adjacency matrix representing the conditional dependency structure between features of a multivariate Gaussian process
}
\details{
This function implements the functional graphical model in Zapata, Oh, and Petersen (2019).
The arguments \code{alpha} and \code{gamma} are a reparameterization of the Group Graphical Lasso tuning parameters when using the \code{JGL} package. When using \code{JGL::JGL}, the tuning parameters are computed as \code{lambda1 = alpha*gamma} and \code{lambda2 = (1-alpha)*gamma}
}
\examples{
## Variables
# Omega - list of precision matrices, one per eigenfunction
# Sigma - list of covariance matrices, one per eigenfunction
# theta - list of functional  principal component scores
# phi - list of eigenfunctions densely observed on a time grid
# y - list containing densely observed multivariate (p-dimensional) functional data 

library(mvtnorm)
library(fda)

## Generate data y
 source(system.file("exec", "getOmegaSigma.R", package = "fgm"))
 theta = lapply(1:nbasis, function(b) t(rmvnorm(n = 100, sigma = Sigma[[b]])))
 theta.reshaped = lapply( 1:p, function(j){
     t(sapply(1:nbasis, function(i) theta[[i]][j,]))
 })
 phi.basis=create.fourier.basis(rangeval=c(0,1), nbasis=21, period=1)
 t = seq(0, 1, length.out = time.grid.length)
 chosen.basis = c(2, 3, 6, 7, 10, 11, 16, 17, 20, 21)
 phi = t(predict(phi.basis, t))[chosen.basis,]
 y = lapply(theta.reshaped, function(th) t(th)\%*\%phi)
 
## Solve
 fgm(y, alpha=0.5, gamma=0.8)
 

}
\references{
Zapata J., Oh S. and Petersen A. (2019) - Partial Separability and Functional Graphical Models for Multivariate Gaussian Processes. Available at \url{https://arxiv.org/abs/1910.03134}.
}
\author{
Javier Zapata, Sang-Yun Oh and Alexander Petersen
}
\keyword{components}
\keyword{fda}
\keyword{fpca}
\keyword{partial}
\keyword{pca}
\keyword{pfpca}
\keyword{principal}
\keyword{separability}
