% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_sum}
\alias{contr_code_sum}
\title{Sum code a factor}
\usage{
contr_code_sum(fct, levels = NULL, omit = length(levels), colnames = NULL)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{omit}{the level to omit (defaults to the last level)}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the factor with contrasts set
}
\description{
Sum coding sets the grand mean as the intercept. 
Each contrast compares one level with the grand mean.
}
\examples{
df <- sim_design(between = list(pet = c("cat", "dog", "bird", "ferret")), 
                 mu = c(2, 4, 9, 13), empirical = TRUE, plot = FALSE)

df$pet <- contr_code_sum(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_sum(df$pet, omit = "cat")
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_sum(df$pet, omit = 1)
lm(y ~ pet, df) \%>\% broom::tidy()
}
