% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-functions.R
\name{fiaparch_sim}
\alias{fiaparch_sim}
\title{Simulate From FIAPARCH Models}
\usage{
fiaparch_sim(
  pars = list(mu = 0, ar = numeric(0), ma = numeric(0), D = 0, omega = 4e-04, phi = 0.2,
    beta = 0.4, gamma = 0.1, delta = 2, d = 0.25, df = 10, shape = 2, P = 3, skew = 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald"),
  n = 1000,
  nstart = 5000,
  trunc = "none"
)
}
\arguments{
\item{pars}{a named list with the parameter specifications; the user
can provide a named list with only the settings they would like to adjust
relative to the default settings.}

\item{cond_dist}{a one-element character vector specifying
the conditional distribution to consider.}

\item{n}{the number of observations to return.}

\item{nstart}{the number of burn-in observations to simulate before
the final \code{n} values to keep; the first \code{nstart} values
are not returned; if a dual model, i.e. with model in the conditional
mean and in the conditional variance, is considered, two times \code{nstart}
is considered in the first simulation step in the conditional variance,
so that \code{n + nstart} values can be fed into the second simulation
step for the conditional mean.}

\item{trunc}{a truncation for the finite-order coefficient series
in long-memory models; can either be the character \code{"none"} for truncation
back to the very first observation at each time point, or to any positive integer
for setting the corresponding truncation length of the infinite-order representation
polynomial.}
}
\value{
A list with four elements is returned: \code{rt} are the simulated
observations, \code{etat} are the underlying innovations,
\code{sigt} are the correspondingly simulated conditional
standard deviations, and \code{cmeans} are the simulated
conditional means. These four elements are formatted as
\code{"ts"} class time series objects.
}
\description{
A streamlined simulation function to simulate from
fractionally integrated asymmetric power autoregressive
conditional heteroskedasticity (FIAPARCH) models.
}
\details{
See the documentation on \code{\link{fiaparch}} for information
on the FIAPARCH model. This function provides
an easy way to simulate from these models.
}
\examples{
sim <- fiaparch_sim(n = 1000)
mat <- do.call(cbind, sim)
plot(mat, main = "")

}
