% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-confounds.R
\name{tag_gaze_coords}
\alias{tag_gaze_coords}
\title{Tag gaze coordinates as on/off screen}
\usage{
tag_gaze_coords(pupil_df, screen_width, screen_height, overshoot_buffer = 0.05)
}
\arguments{
\item{pupil_df}{A data frame containing gaze coordinates}

\item{screen_width}{The screen width in pixels}

\item{screen_height}{The screen height in pixels}

\item{overshoot_buffer}{Additional buffer zone beyond screen edges
(default: \code{0.05}). Expressed as proportion of screen size.
For example, \code{0.05} means 5\% beyond screen edges will still be
considered "on screen"}
}
\value{
A data frame with added column:
\itemize{
\item \code{is_offscreen}: Logical indicating if gaze is outside screen boundaries
}
}
\description{
Identifies when gaze coordinates fall outside the screen boundaries, with an
optional buffer zone to account for potential overshoot in eye tracking.
}
\keyword{internal}
