% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand.R
\name{get_occupancy}
\alias{get_occupancy}
\title{Time-series EV occupancy}
\usage{
get_occupancy(
  sessions,
  dttm_seq = NULL,
  by = "Profile",
  resolution = 15,
  mc.cores = 1
)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{{evprof}} package}

\item{dttm_seq}{sequence of datetime values that will be the \code{datetime}
variable of the returned time-series data frame.}

\item{by}{character, being 'Profile' or 'Session'. When \code{by='Profile'} each column corresponds to an EV user profile.}

\item{resolution}{integer, time resolution (in minutes) of the sessions datetime variables.
If \code{dttm_seq} is defined this parameter is ignored.}

\item{mc.cores}{integer, number of cores to use.
Must be at least one, and parallelization requires at least two cores.}
}
\value{
time-series tibble with first column of type \code{datetime}
}
\description{
Obtain time-series of simultaneously connected EVs from sessions data set
}
\details{
Note that the time resolution of variable \code{ConnectionStartDateTime} must coincide with
\code{resolution} parameter. For example, if a charging session in \code{sessions} starts charging
at 15:32 and \code{resolution = 15}, the load of this session won't be computed. To solve this,
the function automatically aligns charging sessions' start time according to
\code{resolution}, so following the previous example the session would start at 15:30.
}
\examples{
library(lubridate)
library(dplyr)

# Get occupancy with the complete datetime sequence from the sessions
sessions <- head(evsim::california_ev_sessions, 100)
connections <- get_occupancy(
  sessions,
  by = "ChargingStation",
  resolution = 60
)
connections \%>\%
  plot_ts(ylab = "Vehicles connected", legend_show = "onmouseover")

# Get occupancy with a custom datetime sequence and resolution of 15 minutes
sessions <- head(evsim::california_ev_sessions_profiles, 100)
dttm_seq <- seq.POSIXt(
  as_datetime(dmy(08102018)) \%>\% force_tz(tz(sessions$ConnectionStartDateTime)),
  as_datetime(dmy(11102018)) \%>\% force_tz(tz(sessions$ConnectionStartDateTime)),
  by = "15 mins"
)
connections <- get_occupancy(
  sessions,
  dttm_seq = dttm_seq,
  by = "Profile"
)
connections \%>\%
  plot_ts(ylab = "Vehicles connected", legend_show = "onmouseover")

}
