% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ridge.R
\name{mseRidge}
\alias{mseRidge}
\alias{biasRidge}
\alias{varRidge}
\title{Compute MSE, Bias, and Variance for Ridge Estimator}
\usage{
mseRidge(lambda, XtX, beta, sigma2, penalize, ind = 1, XtXlamIinv = NULL)

biasRidge(lambda, XtX, beta, penalize, ind = 1, XtXlamIinv = NULL)

varRidge(lambda, XtX, sigma2 = 1, penalize, ind = 1, XtXlamIinv = NULL)
}
\arguments{
\item{lambda}{penalty parameter value. For \code{biasRidge} and \code{varRidge}, this should be 
a single value. For \code{mseRidge}, either a single value of a list of values.}

\item{XtX}{Cross product of design matrix. Not needed if \code{XtXlamIinv} is provided.}

\item{beta}{True parameter values. Either a vector of length \code{p} or a 
\code{p} x \code{d} matrix.}

\item{sigma2}{Value of the variance parameter}

\item{penalize}{Vector of penalty factors. See \code{\link{estRidge}} for more information.}

\item{ind}{Numerical or logical vector indicating which elements of the bias vector and
variance matrix should be returned. Defaults to the first element.}

\item{XtXlamIinv}{Optional explicit value of \code{(XtX + diag(lambda*penalize))^(-1)}.}
}
\value{
For \code{mseRidge}, a list containing the variance, bias, and MSE. For \code{biasRidge} and \code{varRidge}, a matrix is returned.
}
\description{
Computes the analytic mean-squared error (MSE), bias, and 
	variance for ridge regression estimators given different
	values of the true \code{beta} and \code{sigma2} parameters.
}
\details{
The computations assume that all covariates are correctly included in the
	mean model and bias is due only to penalization. The bias is given by:

		\eqn{-(X'X + \Lambda)^{-1}\Lambda\beta}

	where \eqn{\Lambda = diag(\lambda*penalize)}. The variance is given by: 

		\eqn{\sigma^2(X'X + \Lambda)^{-1}X'X(X'X + \Lambda)^{-1}}
	
	If \code{beta} is provided as a matrix, this will treat
	each column of \code{beta} as a different true parameter vector 
	and return a matrix of bias values (or a vector, if \code{ind} has length 1).

	Providing a pre-computed value of \code{XtXlamIinv} can reduce the computational
	cost in simulations. However, the user is responsible for assuring that the value
	of \code{lambda} provided matches the value used to compute \code{XtXlamIinv}.
}
\author{
Joshua Keller
}
