% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engressionBagged.R
\name{engressionBagged}
\alias{engressionBagged}
\title{Bagged Engression Function}
\usage{
engressionBagged(
  X,
  Y,
  K = 5,
  keepoutbag = TRUE,
  noise_dim = 10,
  hidden_dim = 100,
  num_layer = 3,
  dropout = 0.05,
  num_epochs = 1000,
  lr = 10^(-3),
  beta = 1,
  silent = FALSE,
  standardize = TRUE
)
}
\arguments{
\item{X}{A matrix or data frame representing the predictors.}

\item{Y}{A matrix or vector representing the target variable(s).}

\item{K}{The number of bagged models to fit (default: 5).}

\item{keepoutbag}{A boolean indicating whether to keep the out-of-bag samples and training data (default: TRUE).}

\item{noise_dim}{The dimension of the noise introduced in the model (default: 10).}

\item{hidden_dim}{The size of the hidden layer in the model (default: 100).}

\item{num_layer}{The number of layers in the model (default: 3).}

\item{dropout}{The dropout rate to be used in the model (default: 0.05).}

\item{num_epochs}{The number of epochs to be used in training (default: 1000).}

\item{lr}{The learning rate to be used in training (default: 10^-3).}

\item{beta}{The beta scaling factor for energy loss (default: 1).}

\item{silent}{A boolean indicating whether to suppress output during model training (default: FALSE).}

\item{standardize}{A boolean indicating whether to standardize the input data (default: TRUE).}
}
\value{
A bagged engression model object with class "engressionBagged".
}
\description{
This function fits a bagged engression model to the data by fitting multiple
engression models to subsamples of the data. It allows for the tuning of several parameters
related to model complexity.
}
\examples{
\donttest{
  n = 1000
  p = 5
  X = matrix(rnorm(n*p),ncol=p)
  Y = (X[,1]+rnorm(n)*0.1)^2 + (X[,2]+rnorm(n)*0.1) + rnorm(n)*0.1
  Xtest = matrix(rnorm(n*p),ncol=p)
  Ytest = (Xtest[,1]+rnorm(n)*0.1)^2 + (Xtest[,2]+rnorm(n)*0.1) + rnorm(n)*0.1

  ## fit bagged engression object
  engb = engressionBagged(X,Y,K=3)
  print(engb)

  ## prediction on test data
  Yhat = predict(engb,Xtest,type="mean")
  cat("\n correlation between predicted and realized values:  ", signif(cor(Yhat, Ytest),3))
  plot(Yhat, Ytest,xlab="estimated conditional mean", ylab="observation")

  ## out-of-bag prediction
  Yhat_oob = predict(engb,type="mean")
  cat("\n correlation between predicted and realized values on oob data:  ")
  print(signif(cor(Yhat_oob, Y),3))
  plot(Yhat_oob, Y,xlab="prediction", ylab="observation")

  ## quantile prediction
  Yhatquant = predict(engb,Xtest,type="quantiles")
  ord = order(Yhat)
  matplot(Yhat[ord], Yhatquant[ord,], type="l", col=2,lty=1,xlab="prediction", ylab="observation")
  points(Yhat[ord],Ytest[ord],pch=20,cex=0.5)

  ## sampling from estimated model
  Ysample = predict(engb,Xtest,type="sample",nsample=1)

  ## plot of realized values against first variable
  oldpar <- par()
  par(mfrow=c(1,2))
  plot(Xtest[,1], Ytest, xlab="Variable 1", ylab="Observation")
  ## plot of sampled values against first variable
  plot(Xtest[,1], Ysample[,1], xlab="Variable 1", ylab="Sample from engression model")  
  par(oldpar)
}

}
