% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqnorm.R
\name{qqnorm.emdi}
\alias{qqnorm.emdi}
\alias{qqnorm.ebp}
\alias{qqnorm.fh}
\alias{qqnorm.direct}
\title{Quantile-quantile plots for an emdi object}
\usage{
\method{qqnorm}{emdi}(y, color = c("blue", "lightblue3"), gg_theme = NULL, ...)

\method{qqnorm}{ebp}(y, color = c("blue", "lightblue3"), gg_theme = NULL, ...)

\method{qqnorm}{fh}(y, color = c("blue", "lightblue3"), gg_theme = NULL, ...)

\method{qqnorm}{direct}(y, ...)
}
\arguments{
\item{y}{a model object of type "emdi", either "ebp" or "fh", representing 
point and, if chosen, MSE estimates obtained by the EBP or Fay-Herriot approach 
(see also \code{\link{ebp}} and \code{\link{fh}}).}

\item{color}{a character vector with two elements. The first element defines
the color for the line in the QQ-plots, for the Cook's Distance plot and for
the Box-Cox plot. The second element defines the color for the densities.}

\item{gg_theme}{\code{\link[ggplot2]{theme}} list from package \pkg{ggplot2}.
For using this argument, package \pkg{ggplot2} must be loaded via
\code{library(ggplot2)}. See also Example 4.}

\item{...}{optional arguments passed to generic function.}
}
\value{
Two Q-Q plots in one grid obtained by \code{\link[ggplot2]{ggplot}}.
}
\description{
Normal quantile-quantile plots of the underlying model in the EBP (see also
\code{\link{ebp}}) or Fay-Herriot (see also \code{\link{fh}}) approaches are 
obtained. The plots are obtained by \code{\link[ggplot2]{ggplot}}.
}
\examples{
\donttest{
# Examples for models of type ebp
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")

# With default setting but na.rm = TRUE; with Box-Cox transformation
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + self_empl +
unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow +
house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
na.rm = TRUE)

# Example 1: Creation of default diagnostic plots
qqnorm(emdi_model)

# Example for models of type fh

# Loading data - population and sample data
data("eusilcA_popAgg")
data("eusilcA_smpAgg")

# Combine sample and population data
combined_data <- combine_data(pop_data = eusilcA_popAgg, pop_domains = "Domain",
                              smp_data = eusilcA_smpAgg, smp_domains = "Domain")

# Generation of the emdi object
fh_std <- fh(fixed = Mean ~ cash + self_empl, vardir = "Var_Mean",
             combined_data = combined_data, domains = "Domain", method = "ml", 
             MSE = TRUE)

# Example 5: Creation of default diagnostic plots for Fay-Herriot model
qqnorm(fh_std)

}
}
\seealso{
\code{\link{emdiObject}}, \code{\link{ebp}}, \code{\link{fh}}
}
