% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.excel.emdi.R
\name{write.excel}
\alias{write.excel}
\title{Exports an emdiObject to an excel file}
\usage{
write.excel(object, file = "excel_output.xlsx", indicator = "all",
  MSE = FALSE, CV = FALSE, split = FALSE)
}
\arguments{
\item{object}{an object of type "emdi", representing point and
MSE estimates.}

\item{file}{path and filename of the spreadsheet to create. It should end on .xlsx.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean" "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", "Poverty_Gap", "Gini", 
"Quintile_Share" or the function name/s of "custom_indicator/s"; 
(iii) groups of indicators: "Quantiles", "Poverty" or 
"Inequality". Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (see also \code{\link{ebp}}) 
and do not appear in groups of indicators even though these might belong to 
one of the groups.}

\item{MSE}{logical. If TRUE, the MSE of the emdiObject is exported. Defaults 
to \code{FALSE}.}

\item{CV}{logical. If TRUE, the CV of the emdiObject is exported. Defaults 
to \code{FALSE}.}

\item{split}{logical. If TRUE, point estimates, MSE and CV are written to
different sheets in the excel file. Defaults to \code{FALSE}.}
}
\value{
An excel file is created in your working directory, or at the given
path.
}
\description{
Function \code{write.excel} enables the user to export point and MSE 
estimates as well as diagnostics from \code{summary.emdi} to an excel file. 
The user can choose if the results should be reported in one or several excel 
sheets. Furthermore, a selection of indicators can be specified.
}
\details{
This function creates an excel file via the package
\code{\link{openxlsx}}. The \code{\link{openxlsx}} package requires a zip 
application to be available to R. If this is not the case the authors of 
\code{\link{openxlsx}} suggest the first of the two following ways. 
\itemize{
\item Install Rtools from: http://cran.r-project.org/bin/windows/Rtools/ and
modify the system PATH during installation.
\item If Rtools is installed, but no system path variable is set. One can 
set such a variable temporarily to R by a command like: 
\code{Sys.setenv("R_ZIPCMD" = "PathToTheRToolsFolder/bin/zip.exe")}
}
To check if a zip application is available they recommend the command 
\code{shell("zip")}.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")

# Example with two additional indicators
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
threshold = function(y){0.6 * median(y)}, L= 50, MSE = TRUE, B = 50, 
custom_indicator = list( my_max = function(y, threshold){max(y)},
my_min = function(y, threshold){min(y)}), na.rm = TRUE, cpus = 1)

# Export estimates for all indicators and uncertainty measures and 
# diagnostics to excel
write.excel(emdi_model, file ="excel_output_all.xlsx", indicator = "all", 
MSE = TRUE, CV = TRUE)

# Single excel sheets for point, MSE and CV estimates
write.excel(emdi_model, file ="excel_output_all_split.xlsx", indicator = "all", 
MSE = TRUE, CV = TRUE, split=TRUE)
}
}
\seealso{
\code{\link{direct}}, \code{\link{emdiObject}}, \code{\link{ebp}}
}
