% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-snowflake.R
\name{chat_snowflake}
\alias{chat_snowflake}
\title{Chat with a model hosted on Snowflake}
\usage{
chat_snowflake(
  system_prompt = NULL,
  account = snowflake_account(),
  credentials = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  echo = c("none", "output", "all")
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{account}{A Snowflake \href{https://docs.snowflake.com/en/user-guide/admin-account-identifier}{account identifier},
e.g. \code{"testorg-test_account"}. Defaults to the value of the
\code{SNOWFLAKE_ACCOUNT} environment variable.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them when called, or
\code{NULL}, the default, to use ambient credentials.}

\item{model}{The model to use for the chat (defaults to "claude-3-7-sonnet").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
The Snowflake provider allows you to interact with LLM models available
through the \href{https://docs.snowflake.com/en/user-guide/snowflake-cortex/cortex-llm-rest-api}{Cortex LLM REST API}.
\subsection{Authentication}{

\code{chat_snowflake()} picks up the following ambient Snowflake credentials:
\itemize{
\item A static OAuth token defined via the \code{SNOWFLAKE_TOKEN} environment
variable.
\item Key-pair authentication credentials defined via the \code{SNOWFLAKE_USER} and
\code{SNOWFLAKE_PRIVATE_KEY} (which can be a PEM-encoded private key or a path
to one) environment variables.
\item Posit Workbench-managed Snowflake credentials for the corresponding
\code{account}.
\item Viewer-based credentials on Posit Connect. Requires the \pkg{connectcreds}
package.
}
}

\subsection{Known limitations}{

Note that Snowflake-hosted models do not support images or tool calling.

See \code{\link[=chat_cortex_analyst]{chat_cortex_analyst()}} to chat with the Snowflake Cortex Analyst rather
than a general-purpose model.
}
}
\examples{
\dontshow{if (has_credentials("cortex")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_snowflake()
chat$chat("Tell me a joke in the form of a SQL query.")
\dontshow{\}) # examplesIf}
}
