% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-openrouter.R
\name{chat_openrouter}
\alias{chat_openrouter}
\title{Chat with one of the many models hosted on OpenRouter}
\usage{
chat_openrouter(
  system_prompt = NULL,
  turns = NULL,
  api_key = openrouter_key(),
  model = NULL,
  seed = NULL,
  api_args = list(),
  echo = c("none", "text", "all")
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{OPENAI_API_KEY} environment
variable.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
Sign up at \url{https://openrouter.ai}.

Support for features depends on the underlying model that you use; see
\url{https://openrouter.ai/models} for details.
}
\examples{
\dontrun{
chat <- chat_openrouter()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
