% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/details_mun_zone_local.R
\name{details_mun_zone_local}
\alias{details_mun_zone_local}
\title{Download data on the verification of local elections in Brazil}
\usage{
details_mun_zone_local(year, uf = "all", encoding = "latin1", temp = TRUE)
}
\arguments{
\item{year}{Election year. For this function, only the years 1996, 2000, 2004, 2008, 2012, 2016 and 2020
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). elections_rda}
}
\value{
\code{details_mun_zone_local()} returns a \code{data.frame} with the following variables:
}
\description{
\code{details_mun_zone_local()} downloads and aggregates the data on the verification of local elections in Brazil,
disaggregated by electoral zone. The function returns a \code{data.frame} where each observation
corresponds to a town/zone.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information can be incomplete.
}
\examples{
\dontrun{
df <- details_mun_zone_local(2000)
}
}
