% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{compute_tracer}
\alias{compute_tracer}
\title{Calculate tracers, e.g., trophic level}
\usage{
compute_tracer(
  Q_ij,
  inverse_method = c("Penrose_moore", "Standard"),
  type_i,
  tracer_i = rep(1, nrow(Q_ij))
)
}
\arguments{
\item{Q_ij}{Consumption of each prey i by predator j in units biomass.}

\item{inverse_method}{whether to use pseudoinverse or standard inverse}

\item{type_i}{character vector indicating whether a taxon is "hetero", "auto", or
"detritus"}

\item{tracer_i}{an indicator matrix specifying the traver value}
}
\value{
The vector \deqn{\mathbf{y_i}} resulting from tracer \deqn{\mathbf{x_i}}
}
\description{
Calculate how a tracer propagates through consumption.
}
\details{
Trophic level \eqn{y_i} for each predator \eqn{i} is defined as:

\deqn{ \mathbf{y = l Q^* + 1} }

where \eqn{\mathbf{Q*}} is the proportion consumption for each predator (column)
of different prey (rows).  We identify primary producers as any taxa with no
consumption (a column of 0s), and assign them as the first trophic level.

More generically, a tracer might be used to track movement of biomass through
consumption.  For example, if we have a tracer \eqn{x_i} that is 1 for the
base of the pelagic food chain, and 0 otherwise, then we can calculate
the proportion of pelagic vs. nonpelagic biomass for each taxon:

\deqn{ \mathbf{y = l Q^* + x} }

This then allows us to separate alternative components of the foodweb.
}
