% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{e_calendar}
\alias{e_calendar}
\title{Calendar}
\usage{
e_calendar(e, range, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{range}{Range of calendar format, string or vector.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Calendar
}
\examples{
dates <- seq.Date(as.Date("2017-01-01"), as.Date("2019-12-31"), by = "day")
values <- rnorm(length(dates), 20, 6)
year <- data.frame(date = dates, values = values)

year |>
   e_charts(date) |>
   e_calendar(range = "2017") |>
   e_visual_map(max = 30) |>
   e_heatmap(values, coord_system = "calendar")

# month
year |>
   e_charts(date) |>
   e_calendar(range = "2017-01") |>
   e_visual_map(max = 30) |>
   e_heatmap(values, coord_system = "calendar")

# range
year |>
   e_charts(date) |>
   e_calendar(range = c("2018-01", "2018-07")) |>
   e_visual_map(max = 30) |>
   e_heatmap(values, coord_system = "calendar")

}
\seealso{
\href{https://echarts.apache.org/en/option.html#calendar}{Additional arguments}
}
