% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{e_button}
\alias{e_button}
\title{Button}
\usage{
e_button(e, id, ..., position = "top", tag = htmltools::tags$button)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{id}{A valid CSS id.}

\item{...}{Content of the button, complient with \code{htmltools}.}

\item{position}{Position of button, \code{top} or \code{bottom}.}

\item{tag}{A Valid \code{htmltools::tags} function.}
}
\description{
Add a button to your visualisation.
}
\examples{
iris \%>\% 
  group_by(Species) \%>\% 
  e_charts(Sepal.Length) \%>\% 
  e_line(Sepal.Width) \%>\% 
  e_line(Petal.Length) \%>\% 
  e_highlight(series_name = "setosa", btn = "myBtn") \%>\% 
  e_button("myBtn", "highlight stuff")

}
