% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_download.R
\name{ebv_download}
\alias{ebv_download}
\title{Download an EBV netCDF file}
\usage{
ebv_download(id = NULL, outputdir, overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{id}{Integer or Character. There are three option to identify the
dataset to be downloaded. (1) It can be a single integer value representing
the ID of the dataset. (2) It can be a character string representing the
title of the data set. (3) It can be a character string representing the
DOI of the dataset in the format '10.25829/f2rdp4' (Dataset 'Habitat
availability for African great apes' by Jessica Junker from the EBV Data
Portal). All three identifier can be retrieved by running
\code{\link[=ebv_download]{ebv_download()}} without any arguments which returns a data.frame
of all available data sets and their ID, title and DOI.}

\item{outputdir}{Character. Output directory of the downloaded files.}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE if you want to
overwrite the netCDF and json.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Downloads a netCDF and json file (ACDD metadata) to the given output
directory. If run empty returns a data.frame of all available data sets and
their ID, title and DOI.
}
\description{
Returns the list of all available data sets at the EBV Portal if
you no arguments are given. If an ID is given, the corresponding file
(netCDF) and its metadata (json file) will be downloaded to the given
output directory.
}
\examples{

\donttest{
#' #get all available datasets
datasets <- ebv_download()

ebv_download(id = datasets$id[1], outputdir =
tempdir(), overwrite=TRUE,
verbose=FALSE)
}
}
