% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-subset.R
\name{ebirdst_subset}
\alias{ebirdst_subset}
\alias{ebirdst_subset.data.frame}
\alias{ebirdst_subset.sf}
\alias{ebirdst_subset.SpatRaster}
\title{Subset eBird Status and Trends data spatiotemporally}
\usage{
ebirdst_subset(x, ext)

\method{ebirdst_subset}{data.frame}(x, ext)

\method{ebirdst_subset}{sf}(x, ext)

\method{ebirdst_subset}{SpatRaster}(x, ext)
}
\arguments{
\item{x}{eBird Status and Trends data to subset; either a
\link[terra:SpatRaster-class]{SpatRaster} object with 52 layers (one for each week)
or a data frame with PI or PD data.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to.}
}
\value{
eBird Status and Trends data in the same format as the input data,
but subset in space and time.
}
\description{
Spatiotemporally subset the raster or tabular eBird Status and Trends data.
The spatiotemporal extent should be defined using \code{\link[=ebirdst_extent]{ebirdst_extent()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ebirdst_subset(data.frame)}: PI or PD data

\item \code{ebirdst_subset(sf)}: PI or PD data as an \code{sf} object

\item \code{ebirdst_subset(SpatRaster)}: Status and Trends rasters

}}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# bbox for southern michigan in may
bb_vec <- c(xmin = -86, xmax = -83, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))

# load and subset raster data
abd <- load_raster(path, product = "abundance", resolution = "lr")
abd_ss <- ebirdst_subset(abd, ext = e)
}
}
