% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{ebirdst_download}
\alias{ebirdst_download}
\title{Download eBird Status and Trends Data Products}
\usage{
ebirdst_download(
  species,
  path = ebirdst_data_dir(),
  tifs_only = TRUE,
  force = FALSE,
  show_progress = TRUE,
  pattern = NULL,
  dry_run = FALSE
)
}
\arguments{
\item{species}{character; a single species given as a scientific name, common
name or six-letter species code (e.g. woothr). The full list of valid
species is can be viewed in the \link{ebirdst_runs} data frame included in this
package. To download the example dataset, use "example_data".}

\item{path}{character; directory to download the data to. All downloaded
files will be placed in a sub-directory of this directory named for the
data version year, e.g. "2020" for the 2020 Status Data Products. Each species'
data package will then appear in a directory named with the eBird species
code. Defaults to a persistent data directory, which can be found by
calling \code{ebirdst_data_dir()}.}

\item{tifs_only}{logical; whether to only download the GeoTIFFs for
abundance and occurrence (the default), or download the entire data
package, including data for predictor importance, partial dependence, and
predictive performance metrics.}

\item{force}{logical; if the data have already been downloaded, should a
fresh copy be downloaded anyway.}

\item{show_progress}{logical; whether to print download progress information.}

\item{pattern}{character; regular expression pattern to supply to
\link[stringr:str_detect]{str_detect()} to filter files to download. Note
that some files are mandatory and will always be downloaded.}

\item{dry_run}{logical; whether to do a dry run, just listing files that will
be downloaded. This can be useful when testing the use of \code{pattern} to
filter the files to download.}
}
\value{
Path to the folder containing the downloaded data package for the
given species. If \code{dry_run = TRUE} a list of files to download will be
returned.
}
\description{
Download an eBird Status and Trends data package for a single species, or for
an example species. Accessing Status and Trends data requires an access key,
consult \code{\link[=set_ebirdst_access_key]{set_ebirdst_access_key()}} for instructions on how to obtain and
store this key. The example data consist of the results for Yellow-bellied
Sapsucker subset to Michigan and are much smaller than the full dataset,
making these data quicker to download and process. Only the low resolution
data are available for the example data In addition, the example data are
accessible without an access key.
}
\examples{
\dontrun{
# download the example data
ebirdst_download("example_data")

# download the data package for wood thrush, geotiffs only
ebirdst_download("woothr")
# download the data package for wood thrush, all data
ebirdst_download("woothr", tifs_only = FALSE)

# use pattern to only download low resolution data
# dry_run can be used to see what files will be downloaded
ebirdst_download("lobcur", pattern = "_lr_", dry_run = TRUE)
# use pattern to only download the high res weekly abundance data
ebirdst_download("lobcur", pattern = "abundance_median_hr", dry_run = TRUE)
}
}
