% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_stixels}
\alias{load_stixels}
\title{Load summary data for eBird Status and Trends stixels}
\usage{
load_stixels(path, ext, return_sf = FALSE)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to. The spatial component of the extent object must be provided in
unprojected, latitude-longitude coordinates.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
Data frame, or \link{sf} object if \code{return_sf = TRUE}, containing stixel
summary data. Data are organized with one stixel per row and each stixel
identified by a unique \code{stixel_id}, the centroid of each stixel in space
and time is specified by \code{lat}, \code{lon}, and \code{date}.
}
\description{
eBird Status and Trends divides space and time into variably sized "stixels"
within which individual base models are fit. The process of stixelization is
performed many times and the prediction at any given point is the median of
the predictions from all the stixels that that point falls in. This function
loads summary statistics for each stixel, for example, the size of the
stixels and the number of observations within each stixel.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load stixel summary information
stixels <- load_stixels(path)
dplyr::glimpse(stixels)
}
}
