% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parse_raster_dates}
\alias{parse_raster_dates}
\title{Parse data cube layer names into dates}
\usage{
parse_raster_dates(x)
}
\arguments{
\item{x}{\code{Raster} object; labeled Status and Trends data cube.}
}
\value{
Date vector.
}
\description{
\code{\link[=label_raster_stack]{label_raster_stack()}} labels the layers of a data cube with the associated
week dates in the format of "wYYYY.MM.DD", because of constraints in the
\code{raster} package. This function converts that character vector into an ISO
compliant Date vector.
}
\examples{
\donttest{
# download and load example abundance data
sp_path <- ebirdst_download("example_data")
abd <- load_raster(sp_path, "abundance")

# parse dates
parse_raster_dates(abd)
}
}
