% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-ppms.R
\name{plot_binary_by_time}
\alias{plot_binary_by_time}
\title{Plot binary occurrence metrics by time}
\usage{
plot_binary_by_time(
  path,
  metric = c("kappa", "auc", "sensitivity", "specificity"),
  ext,
  n_time_periods = 52
)
}
\arguments{
\item{path}{character; full path to directory containing the eBird Status and
Trends products for a single species.}

\item{metric}{character; the PPM to plot, either "kappa", "auc",
"sensitivity", or "specificity".}

\item{ext}{\link{ebirdst_extent} object (optional); the spatiotemporal
extent to filter the data to. The temporal component will be ignored since
n_time_periods defines the temporal periods over which to calculate the
PPMs.}

\item{n_time_periods}{integer; number of periods to divide the year into to
calculate the PPMs, e.g. use 52 to divide into weeks and 12 to divide into
months.}
}
\value{
Boxplot of PPM over time.
}
\description{
For a specified number of time periods (ideally weeks or months), plots one
of four (Kappa, AUC, Sensitivity, Specificity) box plots. Provide an
\code{ebirdst_extent} object to see performance within a spatiotemporal extent,
otherwise rangewide performance will be shown.
}
\examples{
\dontrun{
# download and load example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# define a spatiotemporal extent to plot data from
bb_vec <- c(xmin = -86, xmax = -83, ymin = 42.5, ymax = 44.5)
e <- ebirdst_extent(bb_vec, t = c("04-01", "06-30"))

# plot monthly kappa
plot_binary_by_time(path = sp_path, metric = "kappa",
                    ext = e, n_time_periods = 4)
}
}
