% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgm_plot_class.R
\name{edgeevidence}
\alias{edgeevidence}
\alias{plot_edgeevidence}
\title{Edge evidence plot}
\usage{
plot_edgeevidence(
  output,
  evidence_thresh = 10,
  split = FALSE,
  show = "all",
  donotplot = FALSE,
  ...
)
}
\arguments{
\item{output}{Output object from the easybgm function. Supports also objects from the bgm function of the \code{bgms} package.}

\item{evidence_thresh}{Bayes Factor which will be considered sufficient evidence for in-/exclusion, default is 10.}

\item{split}{if TRUE, plot is split in included and excluded edges. Note that by default separate plots are shown and appear after each other in the plot window. To show the plots side-by-side specify par(mfrow = c(1, 2)).}

\item{show}{specifies which edges should be shown, indicated by "all", "included", "inconclusive", "excluded".}

\item{donotplot}{Runs function but does not plot (default is FALSE). Useful for saving the output (i.e. layout) without plotting.}

\item{...}{Additional arguments passed onto \code{qgraph}.}
}
\value{
Returns a plot
}
\description{
The edge evidence plot colors edges according to their hypothesis testing results: blue for included, red for excluded, and gray for inconclusive. This plot can be used to visualize the hypothesis testing results whether edge presence or absence. The edge evidence plot can aid researchers in deciding which edges provide robust inferential conclusions
}
\examples{
\donttest{
library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)
fit <- easybgm(data, type = "continuous",
                iter = 1000  # for demonstration only (> 5e4 recommended)
                )

plot_edgeevidence(fit)

oldpar <- par(mfrow = c(1,1))

par(mfrow = c(1, 2))
plot_edgeevidence(fit, split = TRUE)

#' par(mfrow = c(1, 3))
plot_edgeevidence(fit, show = "included")
plot_edgeevidence(fit, show = "inconclusive")
plot_edgeevidence(fit, show = "excluded")

par(oldpar)
}
}
