% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eComparison.R
\name{eComparison}
\alias{eComparison}
\title{Comparison of Heatmaps and Mantel Test}
\usage{
eComparison(data, fit, D, graph = TRUE)
}
\arguments{
\item{data}{a data frame containing the variables in the model. It is the data frame used for ensemble learning.}

\item{fit}{is e2tree object.}

\item{D}{is the dissimilarity matrix. This is a dissimilarity matrix measuring the discordance between two observations concerning a given classifier of a random forest model. The dissimilarity matrix is obtained with the \link{createDisMatrix} function.}

\item{graph}{A logical value (default: TRUE). If TRUE, heatmaps of both matrices are generated and displayed.}
}
\value{
A list containing three elements:
\itemize{
\item \code{RF HeatMap}: A heatmap plot of the Random Forest-derived proximity matrix.
\item \code{E2Tree HeatMap}: A heatmap plot of the E2Tree-estimated matrix.
\item \code{Mantel Test}: Results of the Mantel test, including the correlation coefficient and significance level.
}
}
\description{
This function processes heatmaps for visual comparison and performs the Mantel test between a proximity matrix derived from Random Forest outputs and a matrix estimated
by E2Tree. Heatmaps are generated for both matrices. The Mantel test quantifies the correlation between the matrices, offering a statistical measure of similarity.
}
\examples{
\donttest{
## Classification:
data(iris)

# Create training and validation set:
smp_size <- floor(0.75 * nrow(iris))
train_ind <- sample(seq_len(nrow(iris)), size = smp_size)
training <- iris[train_ind, ]
validation <- iris[-train_ind, ]
response_training <- training[,5]
response_validation <- validation[,5]

# Perform training:
ensemble <- randomForest::randomForest(Species ~ ., data=training, 
importance=TRUE, proximity=TRUE)

D <- createDisMatrix(ensemble, data=training, label = "Species", 
                          parallel = list(active=FALSE, no_cores = 1))

setting=list(impTotal=0.1, maxDec=0.01, n=2, level=5)
tree <- e2tree(Species ~ ., training, D, ensemble, setting)

eComparison(training, tree, D)


## Regression
data("mtcars")

# Create training and validation set:
smp_size <- floor(0.75 * nrow(mtcars))
train_ind <- sample(seq_len(nrow(mtcars)), size = smp_size)
training <- mtcars[train_ind, ]
validation <- mtcars[-train_ind, ]
response_training <- training[,1]
response_validation <- validation[,1]

# Perform training
ensemble = randomForest::randomForest(mpg ~ ., data=training, ntree=1000, 
importance=TRUE, proximity=TRUE)

D = createDisMatrix(ensemble, data=training, label = "mpg", 
                          parallel = list(active=FALSE, no_cores = 1))  

setting=list(impTotal=0.1, maxDec=(1*10^-6), n=2, level=5)
tree <- e2tree(mpg ~ ., training, D, ensemble, setting)

eComparison(training, tree, D)

}

}
