% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePM.R
\name{mergePM}
\alias{mergePM}
\title{Identity and merge matching PM samples}
\usage{
mergePM(pm, threshold = 10000, method = c("mostcomplete", "first", "combine"))
}
\arguments{
\item{pm}{A list of typed singletons.}

\item{threshold}{LR threshold for positive identification.}

\item{method}{A keyword indicating how to merging matching samples. See Details.}
}
\value{
A list with the following entries:
\itemize{
\item \code{groups}: A list containing the groups of matching samples.
\item \code{LRmat}: A symmetric matrix (with 0s on the diagonal) containing the direct
matching LR values.
\item \code{nonmissing}: A named vector reporting the number of non-missing genotypes
for each sample.
\item \code{pmReduced}: A list of singletons. If \code{use} is "best" or "first", this is
a subset of the input \code{pm}.
}
}
\description{
Computes the direct matching LR of each pair of samples, and merges the
matching samples.
}
\details{
The available methods for merging matched samples are:
\itemize{
\item "mostcomplete": Use the sample with the highest number of non-missing genotypes
\item "first": Use the first in each group, according to the input order
\item "combine": Not implemented yet.
}
}
\examples{

library(forrel)

x = singleton("a") |> profileSim(markers = NorwegianFrequencies[1:4])
y = relabel(x, new = "b")

# Remove one genotype to make the example more interesting
x = setGenotype(x, id = "a", marker = 1, geno = "-/-")

mergePM(list(x, y))

}
\seealso{
\code{\link[=directMatch]{directMatch()}}.
}
