% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Error.R
\name{Error}
\alias{Error}
\alias{erf}
\alias{erf,dual-mehtod}
\alias{erfc}
\alias{erfc,dual-mehtod}
\alias{erfinv}
\alias{erfinv,dual-mehtod}
\alias{erfcinv}
\alias{erfcinv,dual-mehtod}
\alias{erf,dual-method}
\alias{erfinv,dual-method}
\alias{erfc,dual-method}
\alias{erfcinv,dual-method}
\title{Special Functions of Mathematics}
\usage{
erf(x)

\S4method{erf}{dual}(x)

erfinv(x)

\S4method{erfinv}{dual}(x)

erfc(x)

\S4method{erfc}{dual}(x)

erfcinv(x)

\S4method{erfcinv}{dual}(x)
}
\arguments{
\item{x}{dual object.}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
Special mathematical functions related to the error function. 

The function \code{erfc(x)} is a variant of the cumulative normal (or Gaussian) distribution funciton.

The functions \code{erfinv(x)} and \code{erfcinv(x)} respectively implement the inverse functions of \code{erf(x)} and \code{erfc(x)}.
}
\examples{
x <- dual(0.5, 1)
erf(x)
erfc(x)
erfinv(x)
erfcinv(x)

}
