% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscore.R
\name{zscore}
\alias{zscore}
\title{Wrapper for z-normalization}
\usage{
zscore(x, ..., multivariate = FALSE, keep.attributes = FALSE)
}
\arguments{
\item{x}{Data to normalize. Either a vector, a matrix/data.frame where each row is to be
normalized, or a list of vectors.}

\item{...}{Further arguments to pass to \code{\link[base]{scale}}.}

\item{multivariate}{Is \code{x} a multivariate time series? It will be detected automatically if
a list is provided in \code{x}.}

\item{keep.attributes}{Should the mean and standard deviation returned by
\code{\link[base]{scale}} be preserved?}
}
\value{
Normalized data in the same format as provided.
}
\description{
Wrapper for function \code{\link[base]{scale}} that returns zeros instead of \code{NaN}. It also
supports a list of vectors and a matrix input.
}

