% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{include_any}
\alias{include_any}
\title{Include any items matching a criteria}
\usage{
include_any(
  .data,
  ...,
  .headline = .defaultHeadline(),
  na.rm = TRUE,
  .type = "inclusion",
  .asOffshoot = FALSE,
  .tag = NULL
)
}
\arguments{
\item{.data}{a dataframe which may be grouped}

\item{...}{a dplyr filter specification as a set of formulae where the LHS
are predicates to test the data set against, items that match at least one
of the predicates will be included. The RHS is a glue specification,
defining the message, to be entered in the history graph for each predicate
matched. This can refer to grouping variables, variables from the
environment and \{.included\} and \{.matched\} or \{.missing\} (included =
matched+missing), \{.count\} and \{.total\} - group and overall counts
respectively, e.g. "excluding \{.matched\} items and \{.missing\} with
missing values".}

\item{.headline}{a glue specification which can refer to grouping variables
of .data, or any variables defined in the calling environment}

\item{na.rm}{(default TRUE) if the filter cannot be evaluated for a row
count that row as missing and either exclude it (TRUE) or don't exclude it
(FALSE)}

\item{.type}{default "inclusion": used to define formatting}

\item{.asOffshoot}{do you want this comment to be an offshoot of the main
flow (default = FALSE).}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the filtered .data dataframe with the history graph updated with the
summary of included items as a new stage
}
\description{
Apply a set of inclusion criteria and record the actions of the
filter to the \code{dtrackr} history graph. Because of the ... filter specification,
all parameters MUST BE NAMED. This function is the opposite of
\code{\link[=exclude_all]{exclude_all()}} and the filtering criteria work to identify rows to
include i.e. the results include anything that match any of the criteria. If
\code{na.rm=TRUE} they also keep anything that cannot be evaluated by the criteria.
}
\examples{
library(dplyr)
library(dtrackr)

iris \%>\% track() \%>\% group_by(Species) \%>\% include_any(
      Petal.Length > 5 ~ "{.included} long ones",
      Petal.Length < 2 ~ "{.included} short ones"
) \%>\% history()

# simultaneous evaluation of criteria:
data.frame(a = 1:10) \%>\%
  track() \%>\%
  include_any(
    # These two criteria identify the same value and one item is excluded
    a > 1 ~ "{.included} value > 1",
    a != min(a) ~ "{.included} everything but the smallest value",
  ) \%>\%
  status() \%>\%
  history()

# the behaviour is equivalent to dplyr's filter function:
data.frame(a=1:10) \%>\%
  dplyr::filter(a > 1, a != min(a)) \%>\%
  nrow()

# step-wise evaluation of criteria results in a different output
data.frame(a = 1:10) \%>\%
  track() \%>\%
  # Performing the same exclusion sequentially results in 2 items
  # being excluded as the criteria no longer identify the same
  # item.
  include_any(a > 1 ~ "{.included} value > 1") \%>\%
  include_any(a != min(a) ~ "{.included} everything but the smallest value") \%>\%
  status() \%>\%
  history()

# the behaviour is equivalent to dplyr's filter function:
data.frame(a=1:10) \%>\%
  dplyr::filter(a > 1) \%>\%
  dplyr::filter(a != min(a)) \%>\%
  nrow()

}
