% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFrameDS.R
\name{dataFrameDS}
\alias{dataFrameDS}
\title{dataFrameDS called by ds.dataFrame}
\usage{
dataFrameDS(
  vectors = NULL,
  r.names = NULL,
  ch.rows = FALSE,
  ch.names = TRUE,
  clnames = NULL,
  strAsFactors = TRUE,
  completeCases = FALSE
)
}
\arguments{
\item{vectors}{a list which contains the elemental components to combine.
These correspond to the vector of character strings specified in argument x
of the clientside function ds.dataFrame()}

\item{r.names}{NULL or a character vector specifying the names of the rows. Default NULL.}

\item{ch.rows}{logical, if TRUE then the rows are checked for consistency of length and names.
Default FALSE.}

\item{ch.names}{logical, if TRUE then the names of the variables in the data frame
are checked to ensure that they are syntactically valid variable names and are not duplicated.
Default TRUE. In fact, the clientside function ensures no duplicated names can
be presented to dataFrameDS
but this argument is kept to check for other forms of syntactic validity.}

\item{clnames}{a list of characters, the column names of the output data frame.
These are generated by the clientside function from the names of vectors, and
the column names of data.frames and matrices being combined in producing
the output data.frame}

\item{strAsFactors}{logical, if TRUE determines whether character vectors should automatically be
converted to factors? Default TRUE.}

\item{completeCases}{logical. If TRUE indicates that only complete cases should be
included: any rows with missing values in any component will be excluded. Default FALSE.}
}
\value{
a dataframe composed of the specified elemental components will be created on the
serverside and named according to the <newobj> argument of the clientside
function ds.dataFrame()
}
\description{
The serverside function that creates a data frame from
its elemental components. That is: pre-existing data frames;
single variables; and/or matrices
}
\details{
A data frame is a list of variables all with the same number of rows with unique row
names, which is of class 'data.frame'. ds.dataFrame will create a data frame by combining
a series of elemental components which may be pre-existing data.frames, matrices or variables.
A critical requirement is that the length of all component variables, and the
number of rows of the component data.frames or matrices must all be the same. The output
data.frame will then have this same number of rows. The serverside
function dataFrameDS() calls the native R function data.frame()
and several of its arguments are precisely the same as for data.frame().
In consequence, additional information can be sought from the help()
for data.frame().
}
\author{
DataSHIELD Development Team
}
