% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_util_fun.R
\name{is_equal}
\alias{is_equal}
\title{Test two vectors for pairwise (near) equality.}
\usage{
is_equal(x, y, ...)
}
\arguments{
\item{x}{1st vector to compare (required).}

\item{y}{2nd vector to compare (required).}

\item{...}{Other parameters (passed to \code{num_equal()}).}
}
\description{
\code{is_equal} tests if two vectors \code{x} and \code{y} are pairwise equal.
}
\details{
If both \code{x} and \code{y} are numeric, 
\code{is_equal} calls \code{num_equal(x, y, ...)} 
(allowing for some tolerance threshold \code{tol}).  

Otherwise, \code{x} and \code{y} are compared by \code{x == y}. 

\code{is_equal} is a safer way to verify the (near) equality of numeric vectors than \code{==},  
as numbers may exhibit floating point effects.
}
\examples{

# numeric data: 
is_equal(2, sqrt(2)^2)
is_equal(2, sqrt(2)^2, tol = 0)
is_equal(c(2, 3), c(sqrt(2)^2, sqrt(3)^2, 4/2, 9/3))

# other data types:
is_equal((1:3 > 1), (1:3 > 2))                         # logical
is_equal(c("A", "B", "c"), toupper(c("a", "b", "c")))  # character
is_equal(as.Date("2020-08-16"), Sys.Date())            # dates

# as factors:
is_equal((1:3 > 1), as.factor((1:3 > 2)))  
is_equal(c(1, 2, 3), as.factor(c(1, 2, 3)))
is_equal(c("A", "B", "C"), as.factor(c("A", "B", "C"))) 
 
}
\seealso{
\code{\link{num_equal}} function for comparing numeric vectors;
\code{\link{all.equal}} function of the R \strong{base} package;
\code{near} function of the \strong{dplyr} package.

Other numeric functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}

Other utility functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{dec2base}()},
\code{\link{is_vect}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{numeric functions}
\concept{utility functions}
