% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_fun.R
\name{is.wholenumber}
\alias{is.wholenumber}
\title{Test for whole numbers (i.e., integers).}
\usage{
is.wholenumber(x, tol = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{Number(s) to test (required, accepts numeric vectors).}

\item{tol}{Numeric tolerance value.
Default: \code{tol = .Machine$double.eps^0.5} (see \code{?.Machine} for details).}
}
\description{
\code{is.wholenumber} tests if \code{x} contains only integer numbers.
}
\details{
\code{is.wholenumber} does what the \strong{base} R function \code{is.integer} is \strong{not} designed to do: 

\itemize{ 
\item \code{is.wholenumber()} returns TRUE or FALSE depending on whether its numeric argument \code{x} is an integer value (i.e., a "whole" number). 

\item \code{is.integer()} returns TRUE or FALSE depending on whether its argument is of integer type, and FALSE if its argument is a factor.  
}

See the documentation of \code{\link{is.integer}} for definition and details.
}
\examples{
is.wholenumber(1)    # is TRUE
is.wholenumber(1/2)  # is FALSE
x <- seq(1, 2, by = 0.5)
is.wholenumber(x)

# Compare:
is.integer(1+2) 
is.wholenumber(1+2) 

}
\seealso{
\code{\link{is.integer}} function of the R \strong{base} package.

Other utility functions: 
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()}
}
\concept{utility functions}
