% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-callr.R
\name{r_make}
\alias{r_make}
\alias{r_drake_build}
\alias{r_outdated}
\alias{r_recoverable}
\alias{r_missed}
\alias{r_deps_target}
\alias{r_drake_graph_info}
\alias{r_vis_drake_graph}
\alias{r_sankey_drake_graph}
\alias{r_drake_ggraph}
\alias{r_text_drake_graph}
\alias{r_predict_runtime}
\alias{r_predict_workers}
\title{Reproducible R session management for drake functions}
\usage{
r_make(source = NULL, r_fn = NULL, r_args = list())

r_drake_build(target, character_only = FALSE, ..., source = NULL,
  r_fn = NULL, r_args = list())

r_outdated(..., source = NULL, r_fn = NULL, r_args = list())

r_recoverable(..., source = NULL, r_fn = NULL, r_args = list())

r_missed(..., source = NULL, r_fn = NULL, r_args = list())

r_deps_target(target, character_only = FALSE, ..., source = NULL,
  r_fn = NULL, r_args = list())

r_drake_graph_info(..., source = NULL, r_fn = NULL, r_args = list())

r_vis_drake_graph(..., source = NULL, r_fn = NULL, r_args = list())

r_sankey_drake_graph(..., source = NULL, r_fn = NULL,
  r_args = list())

r_drake_ggraph(..., source = NULL, r_fn = NULL, r_args = list())

r_text_drake_graph(..., source = NULL, r_fn = NULL, r_args = list())

r_predict_runtime(..., source = NULL, r_fn = NULL, r_args = list())

r_predict_workers(..., source = NULL, r_fn = NULL, r_args = list())
}
\arguments{
\item{source}{Path to an R script file that
loads packages, functions, etc. and returns a \code{\link[=drake_config]{drake_config()}} object.
There are 3 ways to set this path.
\enumerate{
\item Pass an explicit file path.
\item Call \code{options(drake_source = "path_to_your_script.R")}.
\item Just create a file called "_drake.R" in your working directory
and supply nothing to \code{source}.
}}

\item{r_fn}{A \code{callr} function such as \code{callr::r} or \code{callr::r_bg}.
Example: \code{r_make(r_fn = callr::r)}.}

\item{r_args}{List of arguments to \code{r_fn}, not including \code{func} or \code{args}.
Example: \code{r_make(r_fn = callr::r_bg, r_args = list(stdout = "stdout.log"))}.}

\item{target}{Name of the target.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{...}{Arguments to the inner function. For example, if you want to call
\code{\link[=r_vis_drake_graph]{r_vis_drake_graph()}}, the inner function is \code{\link[=vis_drake_graph]{vis_drake_graph()}}, and
\code{selfcontained} is an example argument you could supply to the ellipsis.}
}
\description{
\code{drake} searches your environment
to detect dependencies, so functions like \code{\link[=make]{make()}}, \code{\link[=outdated]{outdated()}}, etc.
are designed to run in fresh clean R sessions. Wrappers \code{\link[=r_make]{r_make()}},
\code{\link[=r_outdated]{r_outdated()}}, etc. run reproducibly even if your current R session
is old and stale.
}
\details{
\code{\link[=r_outdated]{r_outdated()}} runs the four steps below.
\code{\link[=r_make]{r_make()}} etc. are similar.
\enumerate{
\item Launch a new \code{callr::r()} session.
\item In that fresh session, run the R script from the \code{source} argument.
This script loads packages, functions, global options, etc.
and returns a \code{\link[=drake_config]{drake_config()}} object.
\item In that same session, run \code{\link[=outdated]{outdated()}}
with the \code{config} argument from step 2.
\item Return the result back to master process
(e.g. your interactive R session).
}
}
\section{Recovery}{

\code{make(recover = TRUE, recoverable = TRUE)}
powers automated data recovery.
The default of \code{recover} is \code{FALSE} because
\enumerate{
\item Automated data recovery is still experimental.
\item It has reproducibility issues.
Targets recovered from the distant past may have been generated
with earlier versions of R and earlier package environments
that no longer exist.
}

How it works: if \code{recover} is \code{TRUE},
\code{drake} tries to salvage old target values from the cache
instead of running commands from the plan.
A target is recoverable if
\enumerate{
\item There is an old value somewhere in the cache that
shares the command, dependencies, etc.
of the target about to be built.
\item The old value was generated with \code{make(recoverable = TRUE)}.
}

If both conditions are met, \code{drake} will
\enumerate{
\item Assign the most recently-generated admissible data to the target, and
\item skip the target's command.
}
}

\examples{
\dontrun{
isolate_example("quarantine side effects", {
writeLines(
  c(
    "library(drake)",
    "load_mtcars_example()",
    "drake_config(my_plan)"
  ),
  "_drake.R" # default value of the `source` argument
)
cat(readLines("_drake.R"), sep = "\\n")
r_outdated()
r_make()
r_outdated()
})
}
}
\seealso{
\code{\link[=make]{make()}}
}
