% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_build.R
\name{drake_build}
\alias{drake_build}
\title{Build/process a single target or import.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#questioning'><img src='figures/lifecycle-questioning.svg' alt='Questioning lifecycle'></a>}}{\strong{Questioning}}}
\usage{
drake_build(
  target,
  ...,
  meta = NULL,
  character_only = FALSE,
  replace = FALSE,
  config = NULL
)
}
\arguments{
\item{target}{Name of the target.}

\item{...}{Arguments to \code{\link[=make]{make()}}, such as the plan and environment.}

\item{meta}{Deprecated.}

\item{character_only}{Logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{replace}{Logical. If \code{FALSE},
items already in your environment
will not be replaced.}

\item{config}{Deprecated 2019-12-22.}
}
\value{
The value of the target right after it is built.
}
\description{
Not valid for dynamic branching.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_mtcars_example() # Get the code with drake_example("mtcars").
out <- drake_build(small, my_plan)
# Now includes `small`.
cached()
head(readd(small))
# `small` was invisibly returned.
head(out)
}
})
}
}
\seealso{
\code{\link[=drake_debug]{drake_debug()}}
}
