% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{do_prework}
\alias{do_prework}
\title{Do the prework in the \code{prework}
argument to \code{\link[=make]{make()}}.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
do_prework(config, verbose_packages)
}
\arguments{
\item{config}{A configured workflow from \code{\link[=drake_config]{drake_config()}}.}

\item{verbose_packages}{logical, whether to print
package startup messages}
}
\value{
Inivisibly returns \code{NULL}.
}
\description{
For internal use only.
The only reason this function is exported
is to set up parallel socket (PSOCK) clusters
without too much fuss.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Create a main internal configuration list with prework.
con <- drake_config(my_plan, prework = c("library(knitr)", "x <- 1"))
# Do the prework. Usually done at the beginning of `make()`,
# and for distributed computing backends like "future_lapply",
# right before each target is built.
do_prework(config = con, verbose_packages = TRUE)
# The `eval` element is the environment where the prework
# and the commands in your workflow plan data frame are executed.
identical(con$eval$x, 1) # Should be TRUE.
}
})
}
}
\keyword{internal}
