% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{failed}
\alias{failed}
\title{List the targets that failed in the last call
to \code{\link[=make]{make()}}.}
\usage{
failed(path = getwd(), search = TRUE, cache = drake::get_cache(path =
  path, search = search, verbose = verbose),
  verbose = drake::default_verbose(), upstream_only = FALSE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{+ checks and cache info.}
\item{3:}{+ any potentially missing items.}
\item{4:}{+ imports and writes to the cache.}
}}

\item{upstream_only}{logical, whether to list only those targets
with no failed dependencies.
Naturally accompanies \code{make(keep_going = TRUE)}.}
}
\value{
A character vector of target names.
}
\description{
Together, functions \code{failed} and
\code{\link[=diagnose]{diagnose()}} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
failed() # Should show that no targets failed.
# Build a workflow plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
try(make(bad_plan), silent = TRUE) # error
failed() # "x"
diagnose(x) # Retrieve the cached error log of x.
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}}, \code{\link[=drake_session]{drake_session()}},
\code{\link[=built]{built()}}, \code{\link[=imported]{imported()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
