% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_ui.R
\name{parallelism_choices}
\alias{parallelism_choices}
\title{List the types of supported parallel computing in drake.}
\usage{
parallelism_choices(distributed_only = FALSE)
}
\arguments{
\item{distributed_only}{logical, whether to return only
the distributed backend types, such as \code{Makefile} and
\code{parLapply}}
}
\value{
Character vector listing the types of parallel
computing supported.
}
\description{
These are the possible values of the
\code{parallelism} argument to \code{\link[=make]{make()}}.
}
\details{
Run \code{make(..., parallelism = x, jobs = n)} for any of
the following values of \code{x} to distribute targets over parallel
units of execution.
\describe{
\item{'parLapply'}{launches multiple processes in a single R session
using \code{parallel::\link{parLapply}()}.
This is single-node, (potentially) multicore computing.
It requires more overhead than the \code{'mclapply'} option,
but it works on Windows. If \code{jobs} is \code{1} in
\code{\link[=make]{make()}}, then no 'cluster' is created and
no parallelism is used.}

\item{'mclapply'}{uses multiple processes in a single R session.
This is single-node, (potentially) multicore computing.
Does not work on Windows for \code{jobs > 1}
because \code{\link[=mclapply]{mclapply()}} is based on forking.}

\item{'future_lapply'}{
opens up a whole trove of parallel backends
powered by the \code{future} and \code{future.batchtools}
packages. First, set the parallel backend globally using
\code{future::plan()}.
Then, apply the backend to your drake_plan
using \code{make(..., parallelism = "future_lapply", jobs = ...)}.
But be warned: the environment for each target needs to be set up
from scratch, so this backend type is higher overhead than either
\code{mclapply} or \code{parLapply}.
Also, the \code{jobs} argument only applies to the imports.
To set the max number of jobs, set the \code{workers}
argument where it exists. For example, call
\code{future::plan(multisession(workers = 4))},
then call \code{\link{make}(your_plan, parallelism = "future_lapply")}.
You might also try options(mc.cores = jobs),
or see future::.options
for environment variables that set the max number of jobs.
}

\item{'future'}{
Just like \code{"future_lapply"} parallelism, except that
\enumerate{
\item Rather than use staged parallelism, each target begins as soon as
their dependencies are ready and a worker is available. This
greatly increases parallel efficiency.
\item The \code{jobs} argument to \code{make()} works as intended: in
\code{make(jobs = 4, parallelism = "future")}, 4 workers will run
simultaneously, so at most 4 jobs will run simultaneously.
\item The \code{"future"} backend is experimental, so it is more likely
to have bugs than its counterparts.
}
}

\item{'Makefile'}{uses multiple R sessions
by creating and running a Makefile.
For distributed computing on a cluster or supercomputer,
try \code{\link{make}(..., parallelism = 'Makefile',
  prepend = 'SHELL=./shell.sh')}.
You need an auxiliary \code{shell.sh} file for this,
and \code{\link[=shell_file]{shell_file()}}
writes an example.

Here, Makefile-level parallelism is only used for
targets in your workflow plan
data frame, not imports. To process imported objects and files,
drake selects the best parallel
backend for your system and uses
the number of jobs you give to the \code{jobs}
argument to \code{\link[=make]{make()}}.
To use at most 2 jobs for imports and at most 4 jobs
for targets, run
\code{make(..., parallelism = 'Makefile', jobs = 2, args = '--jobs=4')}

Caution: the Makefile generated by
\code{\link{make}(..., parallelism = 'Makefile')}
is NOT standalone. DO NOT run it outside of
\code{\link[=make]{make()}} or \code{\link[=make]{make()}}.
Also, Windows users will need to download and install Rtools.
}
}
}
\examples{
# See all the parallel computing options.
parallelism_choices()
# See just the distributed computing options.
parallelism_choices(distributed_only = TRUE)
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=shell_file]{shell_file()}}
}
