% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{in_progress}
\alias{in_progress}
\title{List the targets that either
(1) are currently being built during a \code{\link{make}()}, or
(2) were being built if the last \code{\link{make}()} quit unexpectedly.}
\usage{
in_progress(path = getwd(), search = TRUE, cache = drake::get_cache(path =
  path, search = search, verbose = verbose), verbose = TRUE)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
A character vector of target names.
}
\description{
Similar to \code{\link{progress}()}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Kill before targets finish.
# If you interrupted make(), some targets will probably be listed:
in_progress()
})
}
}
\seealso{
\code{\link{diagnose}}, \code{\link{session}},
\code{\link{built}}, \code{\link{imported}},
\code{\link{readd}}, \code{\link{drake_plan}}, \code{\link{make}}
}
