% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_ui.R
\name{drake_batchtools_tmpl_file}
\alias{drake_batchtools_tmpl_file}
\title{Write the batchtools template file
from one of the built-in drake examples.}
\usage{
drake_batchtools_tmpl_file(example = drake::drake_examples(), to = getwd(),
  overwrite = FALSE)
}
\arguments{
\item{example}{Name of the drake example
from which to take the template file.
Must be listed in \code{\link{drake_examples}()}.}

\item{to}{Character vector, where to write the file.}

\item{overwrite}{Logical, whether to overwrite an existing file of the
same name.}
}
\value{
\code{NULL} is returned,
but a batchtools template file is written.
}
\description{
If there are multiple template files in the example,
only the first one (alphabetically) is written.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# List the drake examples. Only some have template files.
drake_examples()
# Write the batchtools template file from the SLURM example.
drake_batchtools_tmpl_file("slurm") # Writes batchtools.slurm.tmpl.
# Find batchtools.slurm.tmpl with the rest of the example's files.
drake_example("slurm") # Writes a new 'slurm' folder with more files.
# Run the basic example with a
# SLURM-powered parallel backend. Requires SLURM.
library(future.batchtools)
# future::plan(batchtools_slurm, template = "batchtools.slurm.tmpl") # nolint
# make(my_plan, parallelism = "future_lapply") # nolint
})
}
}
\seealso{
\code{\link{drake_examples}}, \code{\link{drake_example}},
\code{\link{shell_file}}
}
